SELECT * FROM test
WHERE dane.exist('declare namespace t="http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelManuInstructions";
/t:root/t:Location[@LocationID=1]') = 1

SELECT 
ProductModelID, 
Instructions.query('declare namespace t="http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelManuInstructions";
/t:root/t:Location/t:step') AS Steps
FROM Production.ProductModel
WHERE ProductModelID = 10

WITH XMLNAMESPACES ('http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelManuInstructions' AS t)

SELECT ProductModelID, Instructions.query('/t:root/t:Location/t:step') AS Steps
FROM Production.ProductModel
WHERE ProductModelID = 10

WITH XMLNAMESPACES ('http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelManuInstructions' AS t)

SELECT ProductModelID,
Instructions.value('(/t:root/t:Location/@LotSize)[2]',
'decimal (5,2)') AS Location
FROM Production.ProductModel
WHERE ProductModelID = 10

WITH XMLNAMESPACES ('http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelManuInstructions' AS t)

SELECT ProductModelID,
Instructions.value('(/t:root/t:Location/t:step/t:material)[2]',
'decimal (5,2)') AS Location
FROM Production.ProductModel
WHERE ProductModelID = 10

WITH XMLNAMESPACES ('http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelManuInstructions' AS t)

SELECT ProductModelID,
Instructions.value('(/t:root/t:Location/t:step/t:material)[2]',
'varchar(255)') AS Material
FROM Production.ProductModel
WHERE ProductModelID = 10 


DECLARE @mixInfo XML
SET @mixInfo = 
CAST('
	<Mix>
	 <Tracks>
	  <Track id="1">Raven - Intro</Track>
	  <Track id="2">Track02  Title02</Track>
	  <Track id="3">Track03  Title03</Track>
	  <Track id="4">Track04  Title 04</Track>
	 </Tracks>
	</Mix>' as XML
	)

SELECT Tab.Col.value('.', 'varchar(255)') AS tracklist
FROM @mixInfo.nodes('/Mix/Tracks/Track') as Tab(Col)


SELECT * FROM @mixInfo.nodes('/Mix/Tracks/Track') as Tab(Col)


WITH XMLNAMESPACES ('http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelManuInstructions' AS t)

UPDATE Production.ProductModel
SET Instructions.modify('replace value of (/t:root/t:Location/@LotSize)[2] with 2.5')
WHERE ProductModelID = 10


WITH XMLNAMESPACES ('http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelManuInstructions' AS t)

SELECT ProductModelID,
Instructions.value('(/t:root/t:Location/@LotSize)[2]',
'decimal (5,2)') AS Location
FROM Production.ProductModel
WHERE ProductModelID = 10


WITH XMLNAMESPACES ('http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelManuInstructions' AS t)

UPDATE Production.ProductModel
SET Instructions.modify('
    insert element t:material { "NewMaterial" } as last into
        (/t:root/t:Location[1]/t:step)[1]
')
WHERE ProductModelID = 10


WITH XMLNAMESPACES ('http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelManuInstructions' AS t)

UPDATE Production.ProductModel
SET Instructions.modify('
    delete (/t:root/t:Location[1]/t:step[1]/t:material)[.="NewMaterial"]')
WHERE ProductModelID = 10
